/* $Id: filter.c,v 1.7 1998/07/20 21:06:00 ericb Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

/* This file groups all the functions associated with the filter
   subsystem. */

#include "sema.h"

/*
 *********************************************************************
 This function should not be used, but is kept for Octane
 compatibility.  Use e1432_get_span instead.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_get_decimation_bandwidth(E1432ID hw, SHORTSIZ16 ID,
			       SHORTSIZ16 * bw)
{
    SHORTSIZ16 error, decimation_oversample, tmp;
    FLOATSIZ32 span, clock_freq;
    LONGSIZ32 ratio;

    TRACE_PRINTF(0, ("e1432_get_decimation_bandwidth"
		     "(0x%p, %d, 0x%p)\n",
		     hw, ID, bw));

    /* Get clock_freq, decimation_oversample, span */
    error = e1432_get_clock_freq(hw, ID, &clock_freq);
    if (error)
	return error;
    error = e1432_get_decimation_oversample(hw, ID,
					    &decimation_oversample);
    if (error)
	return error;
    error = e1432_get_span(hw, ID, &span);
    if (error)
	return error;

    tmp = 0;
    ratio = (LONGSIZ32)(clock_freq / (span * 2.56) + 0.5);
    while (ratio > (1L << tmp))
	tmp++;
    if (decimation_oversample == E1432_DECIMATION_OVERSAMPLE_ON)
	tmp--;

    *bw = tmp;

    return 0;
}

/*
 *********************************************************************
 This function should not be used, but is kept for Octane
 compatibility.  Use e1432_set_span instead.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_set_decimation_bandwidth(E1432ID hw, SHORTSIZ16 ID,
			       SHORTSIZ16 BW)
{
    SHORTSIZ16 error, decimation_oversample;
    FLOATSIZ32 span, clock_freq;

    TRACE_PRINTF(0, ("e1432_set_decimation_bandwidth(0x%p, %d, %d)\n",
		     hw, ID, BW));

    /* Get clock_freq, decimation_oversample */
    error = e1432_get_clock_freq(hw, ID, &clock_freq);
    if (error)
	return error;
    error = e1432_get_decimation_oversample(hw, ID,
					    &decimation_oversample);
    if (error)
	return error;
    if (decimation_oversample == E1432_DECIMATION_OVERSAMPLE_ON)
	BW++;

    span = (FLOATSIZ32) (clock_freq / (2.56 * (1L << BW)));

    return e1432_set_span(hw, ID, span);
}

/*
 *********************************************************************
 Set decimation filter parameters.  Returns 0 if all ok, else return
 negative error number.  Because this uses decimation_bandwidth, it
 shouldn't be used, but it is kept for Octane compatibility.  Use
 e1432_set_decimation_output, e1432_set_anti_alias_digital, and
 e1432_set_span instead.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_set_decimation_filter(E1432ID hw, SHORTSIZ16 ID,
			    SHORTSIZ16 output, SHORTSIZ16 state,
			    SHORTSIZ16 decBw)
{
    SHORTSIZ16 error;

    TRACE_PRINTF(0, ("e1432_set_decimation_filter"
		     "(0x%p, %d, %d, %d, %d)\n",
		     hw, ID, output, state, decBw));

    error = e1432_set_decimation_output(hw, ID, output);
    if (error)
	return error;

    error = e1432_set_anti_alias_digital(hw, ID, state);
    if (error)
	return error;

    error = e1432_set_decimation_bandwidth(hw, ID, decBw);
    if (error)
	return error;

    return 0;
}
